#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// ChurningMod01.fsh    by    ChunderFPV  
//https://www.shadertoy.com/view/DtXczr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define A(a) mat2(cos(m.a+vec4(0,11,33,0)))  // rotate
#define C fragColor
#define U fragCoord
//void mainImage( out vec4 C, vec2 U ){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = iTime*6.3,
          d = 0., 
          i = d,
          s;
    vec2 R = iResolution.xy,
         m = (iMouse.xy-.5*R)/R.y*4.; // mouse
    vec3 o = vec3(0, 2, -15), // cam
         u = normalize(vec3((U-.5*R)/R.y, .6)), // coords
         c = vec3(.5, .8, 1), // color
         p, g;
    if (iMouse.z < 1.) // not clicking
        m = -vec2(t/30., .3); // move mouse
    mat2 v = A(y), // pitch (mouse vertical)
         h = A(x); // yaw (mouse horizontal)
    for (; i++<90.;) // raymarch
    {
        p = o+u*d;
        p.yz *= v;
        p.xz *= h;
        p.y -= pow(length(p.xz), 2.)*.02;          // curve horizon up
        p.y += cos(length(round(p.xz))-t/2.);      // make waves
        g = abs(p-round(p));                       // form grid
        s = max(g.x, max(p.y*-sign(m.y), g.z))-.3; // grid to float
        if (s < .001 || d > 90.) break;            // near/far limits
        d += s*.2;                                 // add to scene
    }
    c *= 6./d;    // multiply scene with color & adjust brightness
    c += .1/c;    // orange glow
    c += 16.*s/d; // specular highlights
    fragColor = vec4(c*c*c, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

